﻿using System;
using System.Web;
using System.Web.UI;
using VIRP_WEB.Custom.EFR;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class RelatedLabDetails : UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            LoadObjectDataSourceProperties();

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewRelatedLabDetails.ClientID + "');", true);
        }

        private void LoadObjectDataSourceProperties()
        {
            ObjectDataSourceLabDetails.SelectParameters["CURRENT_USER"].DefaultValue = HttpContext.Current.User.Identity.Name;

            Control baseControl = Parent;
            EfrBasePage basePage = baseControl.Page as EfrBasePage;
            if (basePage != null)
                ObjectDataSourceLabDetails.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = basePage.CurrentRegistryId.ToString();
        }

        public string PatientID
        {
            set
            {
                HiddenFieldPatientID.Value = value;
            }
        }
        public string LabName
        {
            set
            {
                HiddenFieldLabName.Value = value;
            }
        }
        public string SpecimenType
        {
            set
            {
                HiddenFieldSpecimenType.Value = value;
            }
        }
    }
}
